//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiToolButtonBase {
    id : uiToolButton

    property alias iconName : icon.iconName
    property alias iconSize : icon.iconSize
    property bool  down     : false
    property alias tooltip  : tooltip.text

    implicitHeight   : icon.implicitHeight + 16
    implicitWidth    : icon.implicitWidth  + 16
    activeFocusOnTab : false

    UiTooltip { id : tooltip }

    Rectangle {
        id : background

        color        : UiColors.getColor(UiColors.White)
        anchors.fill : parent
        visible      : false
        antialiasing : uiToolButton.antialiasing

        states : [
            State {
                name : "pressed"
                when : uiToolButton.pressed

                PropertyChanges {
                    target  : background
                    color   : UiColors.getColor(UiColors.SelectionGreen)
                    visible : true
                }
                PropertyChanges {
                    target  : border
                    color   : UiColors.getColor(UiColors.SelectionGreen)
                }
            },
            State {
                name : "hovered"
                when : uiToolButton.hovered || uiToolButton.activeFocus

                PropertyChanges {
                    target  : background
                    color   : UiColors.getColor(UiColors.HoverGreen)
                    visible : true
                }
            }
        ]
    }

    UiBorder {
        id : border

        anchors.fill : parent
        width        : 2
        color        : UiColors.getColor(UiColors.Black, 0.14)
        dashWidth    : 7
        gapWidth     : 3
    }

    UiIcon {
        id : icon

        anchors.centerIn : parent
        iconSize         : UiIcon.Icon_32x32

        states : [
            State {
                name : "disabled"
                when : !uiToolButton.enabled

                PropertyChanges {
                    target   : icon
                    disabled : 1.0
                }
            },
            State {
                name : "highlight"
                when : uiToolButton.pressed || uiToolButton.down

                PropertyChanges {
                    target    : icon
                    highlight : 1.0
                }
            }
        ]
    }
}

